/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8238;

import ibm.nways.jdm.common.IPAddress;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm8238.DecoderException;
import ibm.nways.jdm8238.MibInfo;
import ibm.nways.jdm8238.MibValue;
import ibm.nways.ras.RAS;
import java.io.Serializable;
import java.lang.reflect.Field;

public final class MstDecoder {
    private static final int VERSION_1 = 1;
    private static final int VERSION_2 = 2;
    private static final Integer INT_TYPE = new Integer(0);
    private static final int INTEGER_TYPE = 0;
    private static final Integer STR_TYPE = new Integer(1);
    private static final int STRING_TYPE = 1;
    private static final Integer IP_TYPE = new Integer(2);
    private static final int IPADDR_TYPE = 2;
    private static final Integer MAC_TYPE = new Integer(3);
    private static final int MACADDR_TYPE = 3;
    private byte[] values;
    private static int numberOfIndexes;
    private MibInfo mibInfo;
    private static final Object[][] genericModuleInformation;
    private static final Object[][] genericPortInformation;
    private static final Object[][] genericTrunkInformation;

    protected void finalize() throws Throwable {
        this.values = null;
        this.mibInfo = null;
    }

    public final void setMibInfo(MibInfo mibInfo) {
        this.mibInfo = mibInfo;
    }

    private final int decodeInformation(int n, int n2, String string, Object[][] objectArray) throws DecoderException {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            String string2 = (String)objectArray[n4][0];
            String string3 = (String)objectArray[n4][1];
            int n5 = (Integer)objectArray[n4][2];
            switch (n5) {
                case 0: {
                    int n6 = this.values[n++] & 0xFF;
                    ++n3;
                    this.mibInfo.addVar(string3, new MibValue(string, new Integer(n6)));
                    if (!RAS.isEnabled(19, 5)) break;
                    RAS.trace(19, 5, this, "decodeInformation", String.valueOf(string2) + " -> " + n6);
                    break;
                }
                case 1: {
                    int n7;
                    String string4 = "";
                    while (n3 < n2) {
                        n7 = this.values[n++] & 0xFF;
                        ++n3;
                        if (n7 == 0) break;
                        string4 = String.valueOf(string4) + (char)n7;
                    }
                    this.mibInfo.addVar(string3, new MibValue(string, (Serializable)((Object)new String(string4))));
                    if (!RAS.isEnabled(19, 5)) break;
                    RAS.trace(19, 5, this, "decodeInformation", String.valueOf(string2) + " -> " + string4);
                    break;
                }
                case 2: {
                    int n7 = 0;
                    int n8 = 0;
                    while (n8 < 4) {
                        n7 = n7 << 8 | this.values[n++] & 0xFF;
                        ++n3;
                        ++n8;
                    }
                    IPAddress iPAddress = new IPAddress(n7);
                    this.mibInfo.addVar(string3, new MibValue(string, iPAddress));
                    if (!RAS.isEnabled(19, 5)) break;
                    RAS.trace(19, 5, this, "decodeInformation", String.valueOf(string2) + " -> " + iPAddress);
                    break;
                }
                case 3: {
                    byte[] byArray = new byte[6];
                    int n9 = 0;
                    while (n9 < 6) {
                        byArray[n9] = this.values[n++];
                        ++n3;
                        ++n9;
                    }
                    OctetString octetString = new OctetString(byArray);
                    this.mibInfo.addVar(string3, new MibValue(string, octetString));
                    if (!RAS.isEnabled(19, 5)) break;
                    RAS.trace(19, 5, this, "decodeInformation", String.valueOf(string2) + " -> " + octetString);
                    break;
                }
                default: {
                    throw new DecoderException("Unknown decoder type " + n5 + "for metainformation " + objectArray[n4]);
                }
            }
            ++n4;
        }
        return n3;
    }

    private final Object[][] getSpecificModuleMetaInfo(int n) {
        if (n != -1) {
            try {
                Class<?> clazz = this.getClass();
                String string = "specificModuleT" + n + "Indexes";
                Field field = clazz.getDeclaredField(string);
                numberOfIndexes = field.getInt(null);
                if (RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "getSpecificModuleMetaInfo", "Found specific module information for modType -> " + n);
                }
                String string2 = "specificModuleT" + n + "Information";
                Field field2 = clazz.getDeclaredField(string2);
                return (Object[][])field2.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Exception exception) {
                RAS.logException(19, 5, this, "getSpecificModuleMetaInfo", exception);
            }
        }
        return null;
    }

    private final Object[][] getSpecificPortMetaInfo(int n) {
        if (n != -1) {
            try {
                Class<?> clazz = this.getClass();
                String string = "specificPortT" + n + "Indexes";
                Field field = clazz.getDeclaredField(string);
                numberOfIndexes = field.getInt(null);
                if (RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "getSpecificPortMetaInfo", "Found specific port information for modType -> " + n);
                }
                String string2 = "specificPortT" + n + "Information";
                Field field2 = clazz.getDeclaredField(string2);
                return (Object[][])field2.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Exception exception) {
                RAS.logException(19, 5, this, "getSpecificPortMetaInfo", exception);
            }
        }
        return null;
    }

    private final Object[][] getSpecificTrunkMetaInfo(int n) {
        if (n != -1) {
            try {
                Class<?> clazz = this.getClass();
                String string = "specificTrunkT" + n + "Indexes";
                Field field = clazz.getDeclaredField(string);
                numberOfIndexes = field.getInt(null);
                if (RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "getSpecificTrunkMetaInfo", "Found specific trunk information for modType -> " + n);
                }
                String string2 = "specificTrunkT" + n + "Information";
                Field field2 = clazz.getDeclaredField(string2);
                return (Object[][])field2.get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (Exception exception) {
                RAS.logException(19, 5, this, "getSpecificTrunkMetaInfo", exception);
            }
        }
        return null;
    }

    private final void decodeV1Entry(int n, int n2, int n3) throws DecoderException {
        String string;
        int n4;
        if ((n4 = this.values[n++] & 0xFF) != 1) {
            throw new DecoderException("Structure version mismatch. Expected version 1 entry and found version " + n4 + " at pos. " + (n - 1));
        }
        int n5 = this.values[n++] & 0xFF;
        int n6 = this.values[n++] & 0xFF;
        int n7 = this.values[n++] & 0xFF;
        int n8 = this.values[n++] & 0xFF;
        int n9 = this.values[n++] & 0xFF;
        int n10 = this.values[n++] & 0xFF;
        if (RAS.isEnabled(19, 5)) {
            RAS.trace(19, 5, this, "decodeV1Entry", "----- MODULE INFORMATION -----");
            RAS.trace(19, 5, this, "decodeV1Entry", "modSlotIndex -> " + n2);
            RAS.trace(19, 5, this, "decodeV1Entry", "modSubSlotIndex -> " + n3);
        }
        String string2 = "." + n2 + "." + n3;
        int n11 = 0;
        n11 = this.decodeInformation(n, n5, string2, genericModuleInformation);
        if (n11 < n5 && RAS.isEnabled(19, 5)) {
            RAS.trace(19, 5, this, "decodeV1Entry", "Some information was not decoded in the generic module information. Missing " + (n5 - n11) + " bytes.");
        }
        n += n5;
        int n12 = -1;
        int n13 = 0;
        int n14 = 0;
        Serializable serializable = this.mibInfo.getVar("ocModType", string2);
        if (serializable instanceof MibValue) {
            n12 = ((MibValue)serializable).getIntValue();
        }
        if ((serializable = this.mibInfo.getVar("ocModNumPorts", string2)) instanceof MibValue) {
            n13 = ((MibValue)serializable).getIntValue();
        }
        if ((serializable = this.mibInfo.getVar("ocModNumTrunks", string2)) instanceof MibValue) {
            n14 = ((MibValue)serializable).getIntValue();
        }
        Object[][] objectArray = null;
        if (n6 > 0 && (objectArray = this.getSpecificModuleMetaInfo(n12)) != null) {
            String string3 = null;
            string3 = numberOfIndexes == 1 ? "." + n2 : "." + n2 + "." + n3;
            n11 = this.decodeInformation(n, n6, string3, objectArray);
            if (n11 < n6 && RAS.isEnabled(19, 5)) {
                RAS.trace(19, 5, this, "decodeV1Entry", "Some information was not decoded in the specific module information. Missing " + (n6 - n11) + " bytes.");
            }
        }
        n += n6;
        int n15 = 0;
        String string4 = string2;
        if (n13 > 0 && n8 > 0) {
            objectArray = this.getSpecificPortMetaInfo(n12);
        }
        while (n15 < n13) {
            if (RAS.isEnabled(19, 5)) {
                RAS.trace(19, 5, this, "decodeV1Entry", "----- PORT INFORMATION -----");
                RAS.trace(19, 5, this, "decodeV1Entry", "portSlotIndex -> " + n2);
                RAS.trace(19, 5, this, "decodeV1Entry", "portSubSlotIndex -> " + n3);
                RAS.trace(19, 5, this, "decodeV1Entry", "portIndex -> " + (n15 + 1));
            }
            string2 = string4;
            n11 = this.decodeInformation(n, n7, string2 = String.valueOf(string2) + "." + (n15 + 1), genericPortInformation);
            if (n11 < n7 && RAS.isEnabled(19, 5)) {
                RAS.trace(19, 5, this, "decodeV1Entry", "Some information was not decoded in the generic port information. Missing " + (n7 - n11) + " bytes.");
            }
            n += n7;
            if (objectArray != null) {
                string = null;
                string = numberOfIndexes == 2 ? "." + n2 + "." + (n15 + 1) : "." + n2 + "." + n3 + "." + (n15 + 1);
                n11 = this.decodeInformation(n, n8, string, objectArray);
                if (n11 < n8 && RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "decodeV1Entry", "Some information was not decoded in the specific port information. Missing " + (n8 - n11) + " bytes.");
                }
            }
            n += n8;
            ++n15;
        }
        n15 = 0;
        string4 = string2 = "." + n2;
        if (n14 > 0 && n10 > 0) {
            objectArray = this.getSpecificTrunkMetaInfo(n12);
        }
        while (n15 < n14) {
            if (RAS.isEnabled(19, 5)) {
                RAS.trace(19, 5, this, "decodeV1Entry", "----- TRUNK INFORMATION -----");
                RAS.trace(19, 5, this, "decodeV1Entry", "trunkSlotIndex -> " + n2);
                RAS.trace(19, 5, this, "decodeV1Entry", "trunkIndex -> " + (n15 + 1));
            }
            string2 = string4;
            string2 = String.valueOf(string2) + "." + (n15 + 1);
            n11 += this.decodeInformation(n, n9, string2, genericTrunkInformation);
            n += n9;
            if (n11 < n9 && RAS.isEnabled(19, 5)) {
                RAS.trace(19, 5, this, "decodeV1Entry", "Some information was not decoded in the generic trunk information. Missing " + (n7 - n11) + " bytes.");
            }
            if (objectArray != null) {
                string = null;
                string = numberOfIndexes == 2 ? "." + n2 + "." + (n15 + 1) : "." + n2 + "." + n3 + "." + (n15 + 1);
                n11 = this.decodeInformation(n, n10, string, objectArray);
                if (n11 < n10 && RAS.isEnabled(19, 5)) {
                    RAS.trace(19, 5, this, "decodeV1Entry", "Some information was not decoded in the trunk specific information. Missing " + (n10 - n11) + " bytes.");
                }
            }
            n += n10;
            ++n15;
        }
    }

    private final void decodeV2Entry(int n, int n2) throws DecoderException {
        int n3;
        int n4;
        int n5;
        int n6;
        if ((n6 = this.values[n++] & 0xFF) != 2) {
            throw new DecoderException("Structure version mismatch. Expected version 2 entry and found version " + n6 + " at pos. " + (n - 1));
        }
        if ((n5 = this.values[n++] & 0xFF) != 8) {
            throw new DecoderException("Expected maximum of 8 version 1 entries and found " + n5 + " at pos. " + (n - 1));
        }
        if ((n4 = this.values[n++] & 0xFF) > n5) {
            throw new DecoderException("Number of version 1 entries exceeds maximum number. Found number is " + n4 + ". Maximum is " + n5 + " at pos. " + (n - 1));
        }
        if ((n3 = this.values[n++] & 0xFF) != 0) {
            throw new DecoderException("Reserved octet different from 0x00. Found " + n3 + " at pos. " + (n - 1));
        }
        int n7 = 20;
        int n8 = n;
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11;
            int n12;
            if ((n12 = (n11 = this.values[n++] & 0xFF) << 8 | (n10 = this.values[n++] & 0xFF) & 0xFF) == 0) continue;
            int n13 = (n - n8) / 2;
            this.decodeV1Entry(n7, n2, n13);
            n7 += n12;
            ++n9;
        }
    }

    public final boolean decode(byte[] byArray, int n) {
        if (byArray == null) {
            return false;
        }
        if (byArray.length == 0) {
            return false;
        }
        if (RAS.isEnabled(19, 5)) {
            RAS.enter(19, 5, this, "decode");
        }
        boolean bl = true;
        this.values = byArray;
        int n2 = this.values[0] & 0xFF;
        try {
            switch (n2) {
                case 1: {
                    this.decodeV1Entry(0, n, 1);
                    break;
                }
                case 2: {
                    this.decodeV2Entry(0, n);
                    break;
                }
                default: {
                    throw new DecoderException("Unsupported version of MST entry. Found version is " + n2 + " at pos. 0");
                }
            }
        }
        catch (Exception exception) {
            bl = false;
            RAS.logException(19, 5, this, "decode", exception);
        }
        this.values = null;
        if (RAS.isEnabled(19, 5)) {
            RAS.exit(19, 5, this, "decode");
        }
        return true;
    }

    static {
        genericModuleInformation = new Object[][]{{"modType", "1.3.6.1.4.1.49.2.3.1.4.6.1.3", INT_TYPE}, {"modClass", "1.3.6.1.4.1.49.2.3.1.4.6.1.4", INT_TYPE}, {"modDescr", "1.3.6.1.4.1.49.2.3.1.4.6.1.5", STR_TYPE}, {"modVersion", "1.3.6.1.4.1.49.2.3.1.4.6.1.6", STR_TYPE}, {"modNetwork", "1.3.6.1.4.1.49.2.3.1.4.6.1.11", INT_TYPE}, {"modNetworkType", "1.3.6.1.4.1.49.2.3.1.4.6.1.12", INT_TYPE}, {"modStatus", "1.3.6.1.4.1.49.2.3.1.4.6.1.13", INT_TYPE}, {"modNumPorts", "1.3.6.1.4.1.49.2.3.1.4.6.1.14", INT_TYPE}, {"modNumTrunks", "1.3.6.1.4.1.49.2.3.1.4.6.1.15", INT_TYPE}, {"modNumOccupiedSlots", "1.3.6.1.4.1.49.2.3.1.4.6.1.17", INT_TYPE}, {"modSlotOffset", "1.3.6.1.4.1.49.2.3.1.4.6.1.18", INT_TYPE}};
        genericPortInformation = new Object[][]{{"portType", "1.3.6.1.4.1.49.2.3.1.4.11.1.4", INT_TYPE}, {"portConnector", "1.3.6.1.4.1.49.2.3.1.4.11.1.5", INT_TYPE}, {"portStatus", "1.3.6.1.4.1.49.2.3.1.4.11.1.6", INT_TYPE}, {"portAdminState", "1.3.6.1.4.1.49.2.3.1.4.11.1.7", INT_TYPE}, {"portNetwork", "1.3.6.1.4.1.49.2.3.1.4.11.1.8", INT_TYPE}, {"portNetworkType", "1.3.6.1.4.1.49.2.3.1.4.11.1.9", INT_TYPE}, {"portAlertMode", "1.3.6.1.4.1.49.2.3.1.4.11.1.10", INT_TYPE}};
        genericTrunkInformation = new Object[][]{{"trunkType", "1.3.6.1.4.1.49.2.3.1.4.3.1.3", INT_TYPE}, {"trunkConnector", "1.3.6.1.4.1.49.2.3.1.4.3.1.4", INT_TYPE}, {"trunkStatus", "1.3.6.1.4.1.49.2.3.1.4.3.1.5", INT_TYPE}, {"trunkAdminState", "1.3.6.1.4.1.49.2.3.1.4.3.1.6", INT_TYPE}, {"trunkWrapState", "1.3.6.1.4.1.49.2.3.1.4.3.1.7", INT_TYPE}, {"trunkNeighbor", "1.3.6.1.4.1.49.2.3.1.4.3.1.8", INT_TYPE}, {"trunkNetwork", "1.3.6.1.4.1.49.2.3.1.4.3.1.9", INT_TYPE}, {"trunkNetworkType", "1.3.6.1.4.1.49.2.3.1.4.3.1.10", INT_TYPE}};
    }
}

